/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.persist.PersistentData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjectId
extends ClassId {
    private HashMap keys = new HashMap();
    private String string = null;
    private static final String TRACE_MASKT = "XFRMOIDT";
    private static final String TRACE_MASKF = "XFRMOIDF";
    private static final String TRACE_MASKD = "XFRMOIDD";
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = -6245973564729479257L;

    public ObjectId() {
    }

    public ObjectId(String packageName, String className) {
        super(packageName, className);
    }

    public ObjectId(Object object) {
        super(object);
    }

    public ObjectId(String id) {
        String objectName;
        String packageName = null;
        String className = null;
        String instance = null;
        int separatorIx = id.indexOf(91);
        if (separatorIx == -1) {
            objectName = id;
        } else {
            objectName = id.substring(0, separatorIx);
            instance = id.substring(separatorIx);
        }
        separatorIx = objectName.lastIndexOf(46) + 1;
        if (separatorIx == 0) {
            throw new IllegalArgumentException("Cannot find the package name in object id \"" + id + "\"");
        }
        packageName = objectName.substring(0, separatorIx - 1);
        className = objectName.substring(separatorIx);
        this.setPackageName(packageName);
        this.setClassName(className);
        if (instance != null) {
            if (!instance.endsWith("]")) {
                throw new IllegalArgumentException("Instance identifiers does not end in ']' in object id \"" + id + "\"");
            }
            instance = instance.substring(1, instance.length() - 1);
            int propertyStart = 0;
            int instanceLen = instance.length();
            for (int ix = 0; ix < instanceLen; ++ix) {
                char c = instance.charAt(ix);
                if (c == ',') {
                    this.parseProperty(instance.substring(propertyStart, ix).trim());
                    propertyStart = ix + 1;
                    continue;
                }
                if (c == '\"') {
                    ix = this.skipQuote(instance, ix + 1, '\"');
                    continue;
                }
                if (c != '[') continue;
                ix = this.skipQuote(instance, ix + 1, ']');
            }
            this.parseProperty(instance.substring(propertyStart).trim());
        }
    }

    public ObjectId(PersistentData data) {
        this(((Persistent)data).persistentForm);
    }

    public ClassId getClassId() {
        return new ClassId(this.getPackageName(), this.getClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyProperty(String name, Object value) {
        if (!(value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof ObjectId)) {
            throw new IllegalArgumentException("Key property values must be of type Boolean, Number, String or ObjectId");
        }
        this.string = null;
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            this.keys.put(name, value);
        }
    }

    public void setKeyProperties(Map properties) {
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry property = iterator.next();
            Object key = property.getKey();
            Object value = property.getValue();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Property key must be of type String: " + key);
            }
            if (value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof ObjectId) continue;
            throw new IllegalArgumentException("Property value must be of type Boolean, Number, String or ObjectId: " + value);
        }
        this.keys = new HashMap(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getKeyProperty(String name) {
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            return this.keys.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getKeyProperties() {
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            return (Map)this.keys.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.string == null) {
            StringBuffer buff = new StringBuffer(super.toString());
            HashMap hashMap = this.keys;
            synchronized (hashMap) {
                if (!this.keys.isEmpty()) {
                    buff.append("[");
                    Set keySet = this.keys.keySet();
                    Collection values = this.keys.values();
                    Iterator keysIterator = keySet.iterator();
                    Iterator valuesIterator = values.iterator();
                    boolean first = true;
                    while (keysIterator.hasNext()) {
                        String key = (String)keysIterator.next();
                        Object value = valuesIterator.next();
                        if (first) {
                            first = false;
                        } else {
                            buff.append(", ");
                        }
                        buff.append(key).append("=");
                        if (value instanceof Number || value instanceof Boolean) {
                            buff.append(value.toString());
                            continue;
                        }
                        if (value instanceof ObjectId) {
                            buff.append("ref(").append(value.toString()).append(")");
                            continue;
                        }
                        buff.append("\"").append(value.toString()).append("\"");
                    }
                    buff.append("]");
                }
            }
            this.string = buff.toString();
        }
        return this.string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof ObjectId) {
            result = super.equals(object);
            HashMap hashMap = this.keys;
            synchronized (hashMap) {
                result &= this.keys.equals(((ObjectId)object).keys);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int result = super.hashCode();
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
        }
        return result += this.keys.hashCode();
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.persistentForm = this.toString();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void parseProperty(String property) {
        void var2_5;
        Object value;
        int separator = property.indexOf(61);
        if (separator == -1) {
            throw new IllegalArgumentException("Error parsing property.  Cannot find '=' in \"" + property + "\"");
        }
        String propertyName = property.substring(0, separator);
        String propertyValue = property.substring(separator + 1);
        if (propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
            value = propertyValue.substring(1, propertyValue.length() - 1);
        } else if (propertyValue.equalsIgnoreCase("true")) {
            value = new Boolean(true);
        } else if (propertyValue.equalsIgnoreCase("false")) {
            value = new Boolean(false);
        } else if (propertyValue.startsWith("ref(") && propertyValue.endsWith(")")) {
            value = new ObjectId(propertyValue.substring(4, propertyValue.length() - 1));
        } else {
            try {
                value = new Double(Double.parseDouble(propertyValue));
            }
            catch (NumberFormatException exc) {
                throw new IllegalArgumentException("Error parsing property.  Invalid property value " + propertyValue + " in \"" + property + "\"");
            }
        }
        this.setKeyProperty(propertyName, var2_5);
    }

    private int skipQuote(String string, int startIx, char endQuote) {
        int result = -1;
        int stringLen = string.length();
        while (result == -1 && startIx < stringLen) {
            char c = string.charAt(startIx);
            if (c == endQuote) {
                result = startIx;
            } else if (c == '\"') {
                startIx = this.skipQuote(string, startIx + 1, '\"');
            } else if (c == '[') {
                startIx = this.skipQuote(string, startIx + 1, ']');
            }
            ++startIx;
        }
        if (result == -1) {
            throw new IllegalArgumentException("Unbalanced quote character in object \"" + string + "\"");
        }
        return result;
    }

    class Persistent
    implements PersistentData {
        String persistentForm;
        private static final long serialVersionUID = -370637458038671199L;

        Persistent() {
        }
    }
}

